<?php
$metattitle = 'iGaming Infrastructure - KSK Holding SIA';
require_once (__DIR__ . '/../sections/head.php');
require_once (__DIR__ . '/../sections/header.php');
?>

<div class="sectionimg grid-container icon-toplp">
	<img width="320" src="data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20viewBox='0%200%20340%200'%3E%3C/svg%3E" data-lazy-src="/images/bg-icons/1.svg" class="kartinkadizain">
</div>

<div class="sectionimg grid-container icon-toplp">
  <img width="320" src="data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20viewBox='0%200%20340%200'%3E%3C/svg%3E" class="kartinkadizain">
</div>

<section class="what-we-do imgsection teleblockpadding-top-0">
  <div class="grid-container teleblockcontent">
    <h1 class="section_heading">Reliable<br> iGaming Infrastructure</h1>
    <div class="teleblocktext">
      <p>
        Providing a seamless infrastructure for iGaming
      </p>
    </div>
    <div class="roomblockline"></div>
    <div class="grid-x">
      <div class="cell colmd6 roomcontent">
        <p>
     At KSK, we specialize in providing comprehensive iGaming infrastructure solutions that empower your gaming platform. Our expertise lies in designing, developing, and optimizing the essential components that form the backbone of a successful iGaming operation. Here's what we do to enhance your iGaming infrastructure.
        </p>
      </div>
      <div class="cell colmd5 roomimg">
        <img src="/images/igaming-infrastructure.webp" />
      </div>
    </div>
    <h2 class="descr-content-room">Optimized Solutions for<br> Peak Performance in iGaming</h2>
    <div class="teleblockline"></div>
    <div class="grid-x">
      <div class="cell colmd4 teleblocktileser">
        <div class="expnumeber">
          1
        </div>
        <h5 class="teleblocksubtitler">Robust architecture</h5>
        <p>We design and build robust architecture for iGaming</p>
      </div>
      <div class="cell colmd4 teleblocktileser">
        <div class="expnumeber">
          2
        </div>
        <h5 class="teleblocksubtitle">Database Management</h5>
        <p>We use advanced technologies and methods to optimise the database</p>
      </div>
      <div class="cell colmd4 teleblocktileser">
        <div class="expnumeber">
          3
        </div>
        <h5 class="teleblocksubtitle">Third-Party Systems</h5>
        <p>Payment gateways, gaming service providers, and customer support</p>
      </div>
    </div>
  </div>
</section>

<section class="our-works imgsection" id="whatweoffer">
	<div class="ourwork-bsicon">
		<img width="420" src="data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20viewBox='0%200%20420%200'%3E%3C/svg%3E" data-lazy-src="/images/bg-icons/4.svg">
	</div>
  
  <div class="grid-container teleblockcontentsecond">
    <h3 class="section_heading">Expert<br>Project Management</h3>
    <div class="teleblocktextsecondbl">
      <p>
        We pride ourselves on our experienced team and efficient project management
      </p>
    </div>
    <div class="teleblockfeatures cell grid-x">
      <div class="medium-auto small-6">
        <div class="teleblockfeature secondblockpag">
          <div class="offertitle">
           Seasoned<br> Project Managers
          </div>
          <p>Our specialists have a proven track record of successfully managing complex projects, ensuring they run smoothly from start to finish.
          </p>
        </div>
      </div>
      <div class="medium-auto small-6">
        <div class="teleblockfeature secondblockpag">
          <div class="offertitle">
            Efficient<br> Planning and Execution
          </div>
          <p>
            Our project management specialists excel at efficient planning and execution. They carry out a comprehensive analysis of project requirements, create detailed project plans and develop clear milestones and deadlines. 
          </p>
        </div>
      </div>
      <div class="medium-auto small-12">
        <div class="teleblockfeature secondblockpag">
          <div class="offertitle">
           Effective Stakeholder Communication
          </div>
          <p>
            Effective communication is a hallmark of our approach to project management. Our project managers build strong relationships with our stakeholders, including clients, developers, designers and other stakeholders. 
          </p>
        </div>
      </div>
    </div>
</section>

<section class="what-we-do imgsection thirdblockpag teleblockpadding-top-0">
  <div class="grid-container teleblockcontent">
    <h3 class="section_heading">Ensuring<br> your platform's success</h3>
    <div class="teleblocktextthirdbl">
      <p>
       Prioritizing the Uninterrupted Operation of Your iGaming Infrastructure
      </p>
    </div>
    <div class="teleblockline"></div>
    <div class="grid-x">
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          01
        </div>
        <h5 class="teleblocksubtitle">Customized Infrastructure Solutions</h5>
        <p>We design and implement a scalable architecture to meet the changing needs of your iGaming platform.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          02
        </div>
        <h5 class="teleblocksubtitle">Data Security and Privacy</h5>
        <p>We adhere to industry standards and regulations to ensure that your platform has the highest level of security and compliance.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          03
        </div>
        <h5 class="teleblocksubtitle">Content Delivery Networks (CDN)</h5>
        <p>By using CDNs, we optimise the player experience and minimise latency during gameplay.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          04
        </div>
        <h5 class="teleblocksubtitle">Scalability and Elasticity</h5>
        <p>
        We design your iGaming infrastructure with scalability and elasticity in mind. As your player base grows or during periods of peak traffic.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          05
        </div>
        <h5 class="teleblocksubtitle">Data Management and Analytics</h5>
        <p>
          We can help you implement robust data management systems and analytical tools to provide valuable insights into your platform.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          06
        </div>
        <h5 class="teleblocksubtitle">Disaster Recovery</h5>
        <p>
       We do data replication, regular backups and failover mechanisms to ensure rapid recovery of your platform.
        </p>
      </div>
    </div>
  </div>
</section>


<section class="imgsection" id="portfollio">
	<div class="grid-container teleblockcontent">
		<div class="teleblockline linewhite"></div>
		<div class="grid-x mbig">
			<div class="cell colmd6">
				<h3 class="section_heading">KSK iGaming
				<br />
			Portfolio</h3>
			</div>
			</div>
	</div>
</section>

<section class="portfolioblock">
		<swiper-container init="false" speed="500" loop="true"  pagination="true">
			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture9.webp" /> 
			</swiper-slide>
			
			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture10.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture2.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture11.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture12.webp" />
					</swiper-slide>
				
					<swiper-slide class="portgall image_item4">
				<img src="/images/Picture5.webp" />
			</swiper-slide>
			
				<swiper-slide class="portgall image_item1">
				<img src="/images/Picture6.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture3.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture13.webp" />
			</swiper-slide>
			
			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture14.webp" />
			</swiper-slide>
			
			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture15.webp" />
			</swiper-slide>
			
			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture16.webp" />
			</swiper-slide>
			
	</swiper-container>
	<div class="photos-itemimg__content">
		<div class="grid-container">

			<div class="grid-x mbig align-center">

				<!-- <div class="cell colmd1"></div>
				<div class="cell colmd12 text-center">
					<h2>Rapidly growing market </h2>
				</div>
				<div class="cell colmd12 text-center">
					<p>
						At least 8 companies targeting to open live casino business on the 40 billion market in 2021.
						<br />
						We do difference.
					</p>
				</div> -->

				<div class="cell colmd1"></div>

				<div class="cell colmd12 text-center">
					<a href="/contacts/" class="button contactsbtn">Contacts</a>
				</div>
			</div>
		</div>
	</div>
</section>

<div id="overlay"></div>
<div id="additionalinfo" class="additionalinfo">
        <div class="controls">
            <h3>Information</h3>
            <div class="btnclose" onclick="off()">✖</div>
        </div>
        <table id="producttext" class="producttext">
		</table>
    </div>
<script>
	const swiperEl = document.querySelector('swiper-container');

	  // swiper parameters
	  const swiperParams = {
	    slidesPerView: 2,
	    breakpoints: {
	      640: {
	        slidesPerView: 3,
	      },
	      1024: {
	        slidesPerView: 5,
	      },
	    },
	    mousewheel: {
		    forceToAxis: true,
		  },
	    on: {
	      init() {
	        // ...
	      },
	    },
	  };
	  
	    // now we need to assign all parameters to Swiper element
  Object.assign(swiperEl, swiperParams);

  // and now initialize it
  swiperEl.initialize();
	  
    const buttons = document.getElementById("map-holder").getElementsByTagName("a");

    const buttonPressed = e => {
        history.pushState({}, '', ''); 
        console.log(e.target.getAttribute("data-text"));
        document.getElementById("overlay").style.display = "block";
	document.getElementById("additionalinfo").style.display = "block";
        document.getElementById("producttext").innerHTML = e.target.parentElement.getAttribute("data-text");
    }

    for (let button of buttons) {
        button.addEventListener("click", buttonPressed);
    }

    const overlay = document.getElementById("overlay");
	const additionalinfo = document.getElementById("additionalinfo");

    addEventListener("popstate", () => {
        off();
    });

    overlay.addEventListener('click', () => {
        off();
    })

    function on() {
        overlay.style.display = "block";
		additionalinfo.style.display = "block";
    }

    function off() {
        overlay.style.display = "none";
		additionalinfo.style.display = "none";
    }

</script>
<?php
require_once (__DIR__ . '/../sections/footer.php');
?>